/*
 * Decompiled with CFR 0.152.
 */
package wafflestomper.ghostwriter;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.gui.screens.inventory.LecternScreen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.glfw.GLFW;
import wafflestomper.ghostwriter.gui.screen.GhostwriterEditBookScreen;
import wafflestomper.ghostwriter.gui.screen.GhostwriterLecternScreen;
import wafflestomper.ghostwriter.gui.screen.GhostwriterReadBookScreen;
import wafflestomper.ghostwriter.utilities.Clipboard;
import wafflestomper.ghostwriter.utilities.FileHandler;
import wafflestomper.ghostwriter.utilities.Printer;

@Mod(value="ghostwriter")
public class Ghostwriter {
    public static final Clipboard GLOBAL_CLIPBOARD = new Clipboard();
    public static final Printer PRINTER = new Printer();
    public static final Logger LOG = LogManager.getLogger();
    public static final FileHandler FILE_HANDLER = new FileHandler(GLOBAL_CLIPBOARD);
    private static final Minecraft MC = Minecraft.m_91087_();
    public static File currentPath;
    private boolean lecternArmed = false;

    public Ghostwriter() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLClientSetupEvent event) {
        LOG.info("Setting up...");
    }

    @SubscribeEvent
    public void tick(TickEvent event) {
        if (Ghostwriter.MC.f_91080_ == null) {
            return;
        }
        if (!this.lecternArmed || !Ghostwriter.MC.f_91080_.getClass().equals(LecternScreen.class)) {
            return;
        }
        this.lecternArmed = false;
        LOG.debug("Lectern screen detected!");
        if (Ghostwriter.MC.f_91074_ == null) {
            LOG.error("Aborting GUI replacement because the player is null");
            return;
        }
        if (Ghostwriter.MC.f_91074_.m_6047_()) {
            LOG.debug("Aborting GUI replacement because the player is crouching");
            return;
        }
        LecternScreen ls = (LecternScreen)Ghostwriter.MC.f_91080_;
        ItemStack bookStack = ls.m_6262_().m_39835_();
        LOG.info("Swapping LecternScreen for GhostwriterLecternScreen...");
        Item bookItem = bookStack.m_41720_();
        if (!(bookItem instanceof WritableBookItem) && !(bookItem instanceof WrittenBookItem)) {
            LOG.error("Unknown book type on lectern!");
            return;
        }
        LOG.debug("Replacing the current screen with a GhostwriterLecternScreen");
        GhostwriterLecternScreen g = new GhostwriterLecternScreen(bookStack, ls.m_6262_(), Ghostwriter.MC.f_91074_.m_150109_());
        MC.m_91152_((Screen)g);
        LOG.debug("Lectern GUI swap done!");
    }

    @SubscribeEvent
    public void guiOpen(ScreenEvent.Opening event) {
        Object eventGui = event.getScreen();
        if (eventGui == null) {
            return;
        }
        LOG.debug("GUIOpenEvent: " + eventGui.toString());
        if (!(eventGui.getClass().equals(BookEditScreen.class) || eventGui.getClass().equals(BookViewScreen.class) || eventGui.getClass().equals(LecternScreen.class))) {
            return;
        }
        if (Ghostwriter.MC.f_91074_ == null) {
            LOG.error("Minecraft.player is null. Cannot continue with GUI swap");
            return;
        }
        if (Ghostwriter.MC.f_91074_.m_6047_()) {
            LOG.debug("Aborting GUI replacement because the player is crouching");
            return;
        }
        if (eventGui instanceof LecternScreen) {
            LOG.info("Aborting early GUI replacement (target is a lectern). Setting lectern swap flag");
            this.lecternArmed = true;
            return;
        }
        ItemStack bookStack = Ghostwriter.MC.f_91074_.m_21120_(InteractionHand.MAIN_HAND);
        if (eventGui instanceof BookEditScreen) {
            LOG.debug("Replacing the current screen with a GhostwriterEditBookScreen");
            eventGui = new GhostwriterEditBookScreen((Player)Ghostwriter.MC.f_91074_, bookStack, InteractionHand.MAIN_HAND);
        } else {
            LOG.debug("Replacing the current screen with a GhostwriterReadBookScreen");
            BookViewScreen.WrittenBookAccess bookInfo = new BookViewScreen.WrittenBookAccess(bookStack);
            eventGui = new GhostwriterReadBookScreen((BookViewScreen.BookAccess)bookInfo, bookStack);
        }
        event.setNewScreen(eventGui);
        LOG.debug("GUI swap done!");
    }

    public static boolean debuggerReleaseControl() {
        GLFW.glfwSetInputMode((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)208897, (int)212993);
        return true;
    }
}

